/*
 * GuiController.h
 *
 *  Created on: 29.10.2009
 *      Author: stefan.detter
 */

#ifndef GUICONTROLLER_H_
#define GUICONTROLLER_H_

#include <QObject>

#include <def.h>

class QMainWindow;
class QDockWidget;

class ModelData;

class TreeItem;

class FirmwareUpdateManager;

class Application;
class Reader;


class OpenReaderDialog;
class QrfeAboutDialog;

// Application
class CSettingsDialog;

// Reader - General
class CUpdateDialog;
class CRfePurDialog;
class CRfePurEngineeringDialog;

// Reader - Application Settings
class CRfePurHidKeyboardReaderDialog;
// Tag - Generic
class CGenericReadWriteDialog;

// Tag - Gen2
//class CGen2SimpleTagDialog;
class CGen2TagDialog;
class CGen2TagEngineeringDialog;
class CGen2NxpResetReadProtectDialog;

// Global - Debug
class CRfePurDebugWindow;


class GuiController : public QObject
{
	Q_OBJECT
public:
	GuiController(Application* application, FirmwareUpdateManager* updateManager, ModelData* modelData, QMainWindow* window, QObject* parent = 0);
	virtual ~GuiController();

public slots:
	void unlockEngineeringMode();

	void showAddReaderDialog();
	void showAboutDialog();

	void showSettings ( const TreeItem* t );

	void showApplicationSettings();

	void showReaderSettings(QString readerId, bool fullFunction = true);
	void showReaderAppSettings(QString readerId);
	void showReaderEngineering(QString readerId);

	void showTagSettings(QString readerId, QString tagId, uint antannaId);
	void showTagEngineering(QString readerId, QString tagId, uint antennaId);

	void showPurDebugWindow(bool show);

signals:
	void appendGlobalJob(JobType type, const QList<QVariant>& params);

private:
	void showReaderSettings (Reader* reader, bool fullFunction = true);
	void showReaderAppSettings (Reader* reader);
	void showReaderEngineering (Reader* reader);
	void showTagSettings (Reader* reader, QString tagId, uint antennaId);
	void showTagEngineering (Reader* reader, QString tagId, uint antennaId);

	void createBottomDockWidget(QWidget* w);
	void showBottomDockWidgetTabbed(QDockWidget* w);


private:
	QMainWindow*					m_window;
    Application*					m_application;
    FirmwareUpdateManager*			m_updateManager;
    ModelData* 						m_modelData;

    OpenReaderDialog*					m_openReaderDialog;
    QrfeAboutDialog*					m_aboutDialog;

    CSettingsDialog*					m_settingsDialog;

    CUpdateDialog*						m_updateDialog;
    CRfePurDialog*						m_rfePurDialog;
    CRfePurEngineeringDialog*			m_rfePurEngineeringDialog;

	CRfePurHidKeyboardReaderDialog* 	m_hidKeyboardReaderDialog;

	CGenericReadWriteDialog*			m_genericReadWriteDialog;

	//	CGen2SimpleTagDialog* 				m_gen2SimpleDialog;
    CGen2TagDialog*						m_gen2Dialog;
    CGen2TagEngineeringDialog*			m_gen2EngineeringDialog;
    CGen2NxpResetReadProtectDialog*		m_gen2NxpResetReadProtectDialog;

	CRfePurDebugWindow* 				m_purDebugWindow;

	QMap<QWidget*, QDockWidget*> 		m_bottomDockWidgets;
};

#endif /* GUICONTROLLER_H_ */
